/**
 * PM2 Ecosystem Configuration untuk Shared Hosting
 * 
 * File ini mendefinisikan konfigurasi untuk menjalankan aplikasi Next.js
 * dan provisioning worker menggunakan PM2 process manager.
 * 
 * Usage:
 *   pm2 start ecosystem.config.js
 *   pm2 save
 *   pm2 startup
 * 
 * Monitoring:
 *   pm2 status
 *   pm2 logs
 *   pm2 monit
 * 
 * Management:
 *   pm2 restart all
 *   pm2 stop all
 *   pm2 delete all
 */

module.exports = {
  apps: [
    {
      name: 'esim-app',
      script: 'npm',
      args: 'start',
      instances: 1,
      autorestart: true,
      watch: false,
      max_memory_restart: '1G',
      env: {
        NODE_ENV: 'production',
        PORT: 3000
      },
      error_file: './logs/esim-app-error.log',
      out_file: './logs/esim-app-out.log',
      log_date_format: 'YYYY-MM-DD HH:mm:ss Z',
      merge_logs: true,
      min_uptime: '10s',
      max_restarts: 10,
      restart_delay: 4000
    },
    {
      name: 'esim-worker',
      script: './scripts/start-provisioning-worker.js',
      instances: 1,
      autorestart: true,
      watch: false,
      max_memory_restart: '500M',
      env: {
        NODE_ENV: 'production'
      },
      error_file: './logs/esim-worker-error.log',
      out_file: './logs/esim-worker-out.log',
      log_date_format: 'YYYY-MM-DD HH:mm:ss Z',
      merge_logs: true,
      min_uptime: '10s',
      max_restarts: 10,
      restart_delay: 4000,
      // Cron restart (optional): restart worker setiap hari jam 3 pagi
      // cron_restart: '0 3 * * *'
    }
  ],

  // Deploy configuration (optional)
  deploy: {
    production: {
      user: 'your-ssh-user',
      host: 'your-server-ip',
      ref: 'origin/main',
      repo: 'git@github.com:username/repo.git',
      path: '/path/to/deployment',
      'pre-deploy-local': '',
      'post-deploy': 'npm install && npm run build && pm2 reload ecosystem.config.js --env production',
      'pre-setup': ''
    }
  }
};
