/** @type {import('next').NextConfig} */
const nextConfig = {
  typescript: {
    // Enable TypeScript checks in production
    ignoreBuildErrors: false
  },
  images: {
    remotePatterns: [
      {
        protocol: 'https',
        hostname: 'p.qrsim.net'
      },
      {
        protocol: 'https',
        hostname: 'api.qrserver.com'
      }
    ]
  },
  serverExternalPackages: ['pg'],

  // Disable experimental features for cPanel compatibility
  experimental: {
    // Use stable features only
  }
}

module.exports = nextConfig;
