#!/usr/bin/env node
/**
 * Script to check admin users in database
 * Run: node scripts/check-admin.js
 */

require('dotenv').config();
const { Pool } = require('pg');

const pool = new Pool({
    host: process.env.DB_HOST,
    port: parseInt(process.env.DB_PORT || '5432'),
    database: process.env.DB_NAME,
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    ssl: false
});

async function checkAdmin() {
    try {
        console.log('\n=== Database Connection ===');
        console.log('Host:', process.env.DB_HOST);
        console.log('Database:', process.env.DB_NAME);

        // Check all users with admin role
        const result = await pool.query(`
      SELECT id, email, name, role, is_active, created_at 
      FROM users 
      WHERE role = 'admin' OR role = 'ADMIN'
      ORDER BY created_at
    `);

        console.log('\n=== Admin Users ===');
        if (result.rows.length === 0) {
            console.log('No admin users found!');
        } else {
            result.rows.forEach((user, i) => {
                console.log(`\n[${i + 1}] Admin:`);
                console.log('  ID:', user.id);
                console.log('  Email:', user.email);
                console.log('  Name:', user.name);
                console.log('  Role:', user.role);
                console.log('  Active:', user.is_active);
                console.log('  Created:', user.created_at);
            });
        }

        // Also check resellers table if exists
        try {
            const resellers = await pool.query(`
        SELECT id, email, name, role, status, created_at 
        FROM resellers 
        WHERE role = 'admin' OR role = 'ADMIN'
        ORDER BY created_at
      `);

            if (resellers.rows.length > 0) {
                console.log('\n=== Admin in Resellers Table ===');
                resellers.rows.forEach((user, i) => {
                    console.log(`\n[${i + 1}] Admin:`);
                    console.log('  ID:', user.id);
                    console.log('  Email:', user.email);
                    console.log('  Name:', user.name);
                    console.log('  Role:', user.role);
                    console.log('  Status:', user.status);
                });
            }
        } catch (e) {
            // resellers table might not have role column, ignore
        }

    } catch (error) {
        console.error('Error:', error.message);
    } finally {
        await pool.end();
    }
}

checkAdmin();
