#!/usr/bin/env node
/**
 * Pakasir Payment Simulation Script
 * Untuk testing webhook di mode Sandbox
 * 
 * Usage: node pakasir-simulate.js <order_id> <amount>
 * Example: node pakasir-simulate.js INV123123 99000
 */

// Configuration - sesuaikan dengan project kamu
const CONFIG = {
    project: "roamku",      // Ganti dengan project name kamu
    api_key: "UkEKM7pq5hzkntadSuQTLaT4U4Bj536J",          // Ganti dengan API key kamu
    base_url: "https://app.pakasir.com/api/paymentsimulation"
};

async function simulatePayment(orderId, amount) {
    const payload = {
        project: CONFIG.project,
        order_id: orderId,
        amount: amount,
        api_key: CONFIG.api_key
    };

    console.log(`\n🔄 Simulating payment...`);
    console.log(`   Order ID: ${orderId}`);
    console.log(`   Amount: Rp ${amount.toLocaleString('id-ID')}`);
    console.log(`   Project: ${CONFIG.project}`);
    console.log('-'.repeat(40));

    try {
        const response = await fetch(CONFIG.base_url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(payload)
        });

        console.log(`\n📡 Response Status: ${response.status}`);

        const text = await response.text();
        let result;
        try {
            result = JSON.parse(text);
            console.log('📦 Response Body:');
            console.log(JSON.stringify(result, null, 2));
        } catch {
            console.log(`📦 Response Text: ${text}`);
        }

        if (response.ok) {
            console.log('\n✅ Payment simulation successful!');
        } else {
            console.log(`\n❌ Payment simulation failed (HTTP ${response.status})`);
        }

        return response;

    } catch (error) {
        console.log(`\n❌ Error: ${error.message}`);
        return null;
    }
}

function main() {
    const args = process.argv.slice(2);

    if (args.length < 2) {
        console.log('Usage: node pakasir-simulate.js <order_id> <amount>');
        console.log('Example: node pakasir-simulate.js INV123123 99000');
        console.log('\n⚠️  Pastikan kamu sudah update CONFIG di script ini:');
        console.log('   - project: nama project pakasir kamu');
        console.log('   - api_key: API key pakasir kamu');
        process.exit(1);
    }

    const orderId = args[0];
    const amount = parseInt(args[1], 10);

    if (isNaN(amount)) {
        console.log('❌ Error: amount harus angka');
        process.exit(1);
    }

    simulatePayment(orderId, amount);
}

main();
