require('dotenv').config();
const { Pool } = require('pg');

const pool = new Pool({
    host: process.env.DB_HOST,
    port: parseInt(process.env.DB_PORT || '5432'),
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_NAME,
    ssl: process.env.DB_SSL === 'true' ? { rejectUnauthorized: false } : false
});

async function showAdmins() {
    try {
        const result = await pool.query(`
      SELECT id, email, role, created_at, email_verified 
      FROM users 
      ORDER BY role, created_at
    `);

        console.log('\n=== ALL USERS ===\n');

        result.rows.forEach(u => {
            console.log(`Email: ${u.email}`);
            console.log(`Role: ${u.role}`);
            console.log(`ID: ${u.id}`);
            console.log(`Verified: ${u.email_verified}`);
            console.log(`Created: ${u.created_at}`);
            console.log('---');
        });

        console.log(`\nTotal: ${result.rows.length} users`);

    } catch (error) {
        console.error('Error:', error.message);
    } finally {
        await pool.end();
    }
}

showAdmins();
