require('dotenv').config();
const { Pool } = require('pg');
const bcrypt = require('bcryptjs');

const pool = new Pool({
    host: process.env.DB_HOST,
    port: parseInt(process.env.DB_PORT || '5432'),
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_NAME,
    ssl: process.env.DB_SSL === 'true' ? { rejectUnauthorized: false } : false
});

async function updateAdmin() {
    const client = await pool.connect();

    const newEmail = 'admin@roamku.com';
    const newPassword = '12345678';

    try {
        console.log('\n🔄 Updating admin account...');

        // Hash the new password
        const hashedPassword = await bcrypt.hash(newPassword, 10);

        // Check if admin@roamku.com already exists
        const existingCheck = await client.query(
            `SELECT id, email FROM users WHERE email = $1`,
            [newEmail]
        );

        if (existingCheck.rows.length > 0) {
            console.log(`\n⚠️  User ${newEmail} already exists!`);
            console.log('   Updating password only...');

            await client.query(
                `UPDATE users SET password = $1, updated_at = NOW() WHERE email = $2`,
                [hashedPassword, newEmail]
            );

            console.log('\n✅ Password updated successfully!');
        } else {
            // Update existing admin account
            const result = await client.query(
                `UPDATE users 
         SET email = $1, password = $2, updated_at = NOW() 
         WHERE role = 'admin' 
         RETURNING id, email, role`,
                [newEmail, hashedPassword]
            );

            if (result.rows.length > 0) {
                console.log('\n✅ Admin account updated successfully!');
                console.log(`   ID: ${result.rows[0].id}`);
                console.log(`   Email: ${result.rows[0].email}`);
                console.log(`   Role: ${result.rows[0].role}`);
            } else {
                // No admin found, create new one
                console.log('\n⚠️  No admin found, creating new admin...');

                const insertResult = await client.query(
                    `INSERT INTO users (id, email, password, role, email_verified, created_at, updated_at)
           VALUES (gen_random_uuid(), $1, $2, 'admin', true, NOW(), NOW())
           RETURNING id, email, role`,
                    [newEmail, hashedPassword]
                );

                console.log('\n✅ New admin created!');
                console.log(`   ID: ${insertResult.rows[0].id}`);
                console.log(`   Email: ${insertResult.rows[0].email}`);
                console.log(`   Role: ${insertResult.rows[0].role}`);
            }
        }

        console.log('\n📋 New credentials:');
        console.log(`   Email: ${newEmail}`);
        console.log(`   Password: ${newPassword}`);

    } catch (error) {
        console.error('\n❌ Error:', error.message);
    } finally {
        client.release();
        await pool.end();
    }
}

updateAdmin();
