/**
 * SENTRY EDGE RUNTIME CONFIGURATION
 * 
 * Tracks errors in Edge Runtime (middleware, edge functions)
 */

import * as Sentry from "@sentry/nextjs";

// Get DSN from environment variable
const SENTRY_DSN = process.env.SENTRY_DSN;
const SENTRY_ENVIRONMENT = process.env.SENTRY_ENVIRONMENT || process.env.NODE_ENV || 'development';

if (SENTRY_DSN) {
  Sentry.init({
    dsn: SENTRY_DSN,
    environment: SENTRY_ENVIRONMENT,
    release: process.env.SENTRY_RELEASE || process.env.npm_package_version,
    tracesSampleRate: SENTRY_ENVIRONMENT === 'production' ? 0.1 : 1.0,
    enabled: SENTRY_ENVIRONMENT !== 'development',
  });
} else {
  // Silent fallback - Sentry not initialized without DSN
}
